<?php
require_once __DIR__ . '/../utils/Config.php'; class VisitorManager { private $db; private $gameState; private $upgradeManager; private $adController; public function __construct($db, $gameState, $upgradeManager) { $this->db = $db; $this->gameState = $gameState; $this->upgradeManager = $upgradeManager; require_once SRC_PATH . '/controllers/AdController.php'; $this->adController = new AdController($db, $gameState); } public function calculateVisitors($baseVisitors, $effects) { $gameState = $this->db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $userLimit = $gameState['visitor_limit']; if ($gameState['server_online'] == 0) { return [ 'current' => 0, 'potential' => 0, 'capacity' => $effects['capacity'], 'satisfaction' => $gameState['visitor_satisfaction'], 'limit_active' => ($userLimit > 0), 'user_limit' => $userLimit ]; } $wasRecentlyRestarted = false; $lastRestartTime = $this->db->query("SELECT value FROM game_state_meta WHERE key_name = 'last_restart_time'")->fetchColumn(); if ($lastRestartTime) { $timeSinceRestart = time() - intval($lastRestartTime); if ($timeSinceRestart <= 10) { $wasRecentlyRestarted = true; return [ 'current' => $gameState['current_visitors'], 'potential' => $gameState['total_potential_visitors'], 'capacity' => $effects['capacity'], 'satisfaction' => $gameState['visitor_satisfaction'], 'limit_active' => ($userLimit > 0), 'user_limit' => $userLimit ]; } } $result = $this->db->query( "SELECT id, name, type, popularity, julianday('now') - julianday(created_at) as age_days FROM software WHERE uploaded = 1" )->fetchAll(); $contentPopularity = 0; $oldestContentInDays = 0; $contentCount = count($result); $contentTypes = []; foreach ($result as $software) { $ageInDays = $software['age_days']; $decayFactor = 1.0; if ($ageInDays > 5) { $periodsOld = floor(($ageInDays - 5) / 10); $decayFactor = max(0.05, 1.0 - ($periodsOld * 0.2)); } $typeMultiplier = 1.0; if ($software['type'] == 'Game' || $software['type'] == 'game') { $typeMultiplier = 1.2; $contentTypes['game'] = true; } else if ($software['type'] == 'OS' || $software['type'] == 'os') { $typeMultiplier = 1.5; $contentTypes['os'] = true; } else { $contentTypes['app'] = true; } $contentPopularity += $software['popularity'] * $decayFactor * $typeMultiplier; if ($ageInDays > $oldestContentInDays) { $oldestContentInDays = $ageInDays; } } $contentVisitors = $contentPopularity * 3; $yearFactor = $this->calculateYearFactor(); $timeOfDayFactor = $this->calculateTimeOfDayFactor(); $randomFactor = mt_rand(85, 115) / 100; $initialPotentialVisitors = ($baseVisitors + $contentVisitors) * $yearFactor * $timeOfDayFactor * $randomFactor; $satisfaction = $this->calculateVisitorSatisfaction($contentCount, $oldestContentInDays, $contentTypes, $initialPotentialVisitors, $effects); $satisfactionPower = 3.0; $satisfactionEffect = pow($satisfaction, $satisfactionPower); $baseVisitorsEffect = pow($satisfaction, $satisfactionPower * 0.5); $baseVisitors *= $baseVisitorsEffect; $potentialVisitors = ($baseVisitors + $contentVisitors) * $yearFactor * $timeOfDayFactor * $randomFactor; $potentialVisitorsBefore = $potentialVisitors; $potentialVisitors *= $satisfactionEffect; if ($oldestContentInDays > 60 && $contentCount < 5) { $boredFactor = 0.7; $potentialVisitors *= $boredFactor; } $capacity = $effects['capacity']; $isLimitActive = ($userLimit > 0 && $userLimit <= $capacity); if ($isLimitActive && $potentialVisitors > $userLimit) { $turnAwayPercentage = (($potentialVisitors - $userLimit) / $potentialVisitors) * 100; $limitPenalty = min(0.3, floor($turnAwayPercentage / 10) * 0.05); $newSatisfaction = max(0.2, $satisfaction - $limitPenalty); $this->db->query( "UPDATE game_state SET visitor_satisfaction = ? WHERE id = 1", [$newSatisfaction] ); $satisfaction = $newSatisfaction; } $effectiveCapacity = $isLimitActive ? $userLimit : $capacity; $actualVisitors = min(round($potentialVisitors), $effectiveCapacity); if (!$isLimitActive && $potentialVisitors > $capacity) { } $this->db->query( "UPDATE game_state SET
            current_visitors = ?,
            total_potential_visitors = ?,
            visitor_satisfaction = ?
            WHERE id = 1", [$actualVisitors, round($potentialVisitors), $satisfaction] ); return [ 'current' => $actualVisitors, 'potential' => round($potentialVisitors), 'capacity' => $capacity, 'satisfaction' => $satisfaction, 'limit_active' => $isLimitActive, 'user_limit' => $userLimit ]; } private function calculateVisitorSatisfaction($contentCount, $oldestContentInDays, $contentTypes, $potentialVisitors, $effects) { $satisfaction = 1.0; $capacitySatisfaction = 1.0; $contentFreshnessSatisfaction = 1.0; $contentDiversitySatisfaction = 1.0; $attentionSatisfaction = 1.0; $gameState = $this->db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $capacity = $effects['capacity']; $wasOverCapacity = false; $userLimit = $gameState['visitor_limit']; $isLimitActive = ($userLimit > 0 && $userLimit < $capacity); if ($potentialVisitors > 0 && $potentialVisitors > $capacity && !$isLimitActive) { $overCapacityPercentage = (($potentialVisitors - $capacity) / $capacity) * 100; $capacitySatisfaction = max(0.4, 1.0 - (floor($overCapacityPercentage / 10) * 0.07)); $dissatisfactionDays = $gameState['capacity_dissatisfaction_days'] + 1; $dissatisfactionDays = min(14, $dissatisfactionDays); if ($dissatisfactionDays >= 7 && $gameState['server_online'] == 1) { $this->db->query( "UPDATE game_state SET
                    server_online = 0,
                    current_visitors = 0
                    WHERE id = 1" ); } $this->db->query( "UPDATE game_state SET capacity_dissatisfaction_days = ? WHERE id = 1", [$dissatisfactionDays] ); $wasOverCapacity = true; } else { $dissatisfactionDays = $gameState['capacity_dissatisfaction_days']; if ($dissatisfactionDays > 0) { $dissatisfactionDays -= 0.5; $this->db->query( "UPDATE game_state SET capacity_dissatisfaction_days = ? WHERE id = 1", [$dissatisfactionDays] ); $memoryPenalty = $dissatisfactionDays * 0.02; $capacitySatisfaction = max(0.5, min(0.85, 1.0 - $memoryPenalty)); } } if ($contentCount > 0) { if ($oldestContentInDays > 60) { $contentFreshnessSatisfaction = 0.4; } else if ($oldestContentInDays > 30) { $contentFreshnessSatisfaction = 0.6; } else if ($oldestContentInDays > 15) { $contentFreshnessSatisfaction = 0.8; } if ($contentCount < 3) { $contentFreshnessSatisfaction *= 0.8; } } else { $contentFreshnessSatisfaction = 0.3; } $diversityCount = count($contentTypes); if ($diversityCount === 1) { $contentDiversitySatisfaction = 0.8; } else if ($diversityCount === 2) { $contentDiversitySatisfaction = 1.0; } else if ($diversityCount === 3) { $contentDiversitySatisfaction = 1.15; } $attentionLevel = $gameState['attention_level']; if ($attentionLevel > 75) { $attentionSatisfaction = 0.8; } else if ($attentionLevel > 50) { $attentionSatisfaction = 0.9; } $upgradeSatisfaction = $effects['satisfaction']; $satisfaction = ( ($capacitySatisfaction * 0.35) + ($contentFreshnessSatisfaction * 0.35) + ($contentDiversitySatisfaction * 0.1) + ($attentionSatisfaction * 0.1) + ($upgradeSatisfaction * 0.1) ); $satisfaction = max(0.2, min(1.0, $satisfaction)); return $satisfaction; } private function calculateYearFactor() { $year = $this->gameState['current_year']; if ($year < 2000) { return 0.5; } else if ($year < 2006) { return 0.5; } else if ($year < 2011) { return 1.0; } else if ($year < 2016) { return 1.5; } else if ($year < 2021) { return 2.0; } else { return 2.5; } } private function calculateTimeOfDayFactor() { $hour = $this->gameState['current_hour']; if ($hour >= 2 && $hour <= 5) { return mt_rand(20, 30) / 100; } else if ($hour >= 6 && $hour <= 8) { return mt_rand(40, 55) / 100; } else if ($hour >= 9 && $hour <= 11) { return mt_rand(65, 80) / 100; } else if ($hour >= 12 && $hour <= 13) { return mt_rand(75, 85) / 100; } else if ($hour >= 14 && $hour <= 17) { return mt_rand(90, 100) / 100; } else if ($hour >= 18 && $hour <= 21) { return mt_rand(95, 100) / 100; } else { return mt_rand(50, 65) / 100; } } public function calculateVisitorRevenue() { $state = $this->db->query("SELECT current_visitors, visitor_satisfaction, server_online FROM game_state WHERE id = 1") ->fetch(PDO::FETCH_ASSOC); if (!$state) { return 0.0; } if (intval($state['server_online']) === 0 || intval($state['current_visitors']) <= 0) { return 0.0; } $visitors = intval($state['current_visitors']); $baseRevenue = $visitors * 0.005; $satisfaction = max(0.0, min(1.0, floatval($state['visitor_satisfaction']))); $satisfactionMultiplier = 0.5 + (($satisfaction - 0.3) / 0.9) * 1.0; $baseRevenue *= $satisfactionMultiplier; $activeUpgrades = $this->upgradeManager->getActiveUpgrades(); $revenueBoost = 1.0; foreach ($activeUpgrades as $upgrade) { $effects = $upgrade->getEffects(); if (isset($effects['ad_revenue_boost'])) { $revenueBoost += $effects['ad_revenue_boost']; } } $totalRevenue = $baseRevenue * $revenueBoost; $result = $this->db->query( "SELECT type, COUNT(*) as count FROM software WHERE uploaded = 1 GROUP BY type" )->fetchAll(); $softwareTypeMultiplier = 1.0; foreach ($result as $type) { if (($type['type'] == 'Game' || $type['type'] == 'game') && $type['count'] > 0) { $softwareTypeMultiplier += 0.2; } if (($type['type'] == 'OS' || $type['type'] == 'os') && $type['count'] > 0) { $softwareTypeMultiplier += 0.5; } } $totalRevenue *= $softwareTypeMultiplier; $this->db->query( "UPDATE game_state SET credits = credits + ? WHERE id = 1", [$totalRevenue] ); return $totalRevenue; } public function calculateAttentionIncrease() { $result = $this->db->query("SELECT attention_level FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $currentAttention = $result ? floatval($result['attention_level']) : $this->gameState['attention_level']; $securityLevel = isset($this->gameState['security_level']) ? $this->gameState['security_level'] : 1; $year = isset($this->gameState['current_year']) ? $this->gameState['current_year'] : 2000; $visitors = $this->gameState['current_visitors']; $baseAttentionIncrease = $visitors / 1000; $result = $this->db->query( "SELECT COUNT(*) as count FROM software WHERE uploaded = 1 AND popularity > 70" )->fetch(); $highProfileContent = $result['count'] ?? 0; $contentAttention = $highProfileContent * 0.5; $result = $this->db->query( "SELECT COUNT(*) as count FROM software WHERE cracked = 1 AND uploaded = 0" )->fetch(); $crackedContent = $result['count'] ?? 0; $crackedAttention = $crackedContent * 0.2; $randomFactor = mt_rand(-10, 10) / 100; $effects = $this->upgradeManager->calculateVisitorEffects(); $attentionReduction = 1.0 - $effects['attention_reduction']; $dailyReduction = $effects['daily_attention_reduction']; if ($securityLevel > 1) { $dailyReduction += 0.2 * ($securityLevel - 1); } else { $dailyReduction += 0.1; } $yearScalingFactor = 0.5; if ($year >= 2021) { $yearScalingFactor = 1.5; } else if ($year >= 2016) { $yearScalingFactor = 1.25; } else if ($year >= 2011) { $yearScalingFactor = 1.0; } else if ($year >= 2006) { $yearScalingFactor = 0.75; } $attentionIncrease = ($baseAttentionIncrease + $contentAttention + $crackedAttention + $randomFactor) * $attentionReduction * $yearScalingFactor; $attentionChange = $attentionIncrease - $dailyReduction; $newAttention = $currentAttention + $attentionChange; if ($newAttention >= 100 && $effects['attention_reset'] !== null) { $newAttention = $effects['attention_reset']; $this->db->query( "UPDATE upgrades SET acquired = 0 WHERE type = ? AND name = ?", [Upgrade::TYPE_SECURITY, 'Honeypot'] ); } $newAttention = max(0, min(100, $newAttention)); $this->db->query( "UPDATE game_state SET attention_level = ? WHERE id = 1", [$newAttention] ); return [ 'old_level' => $currentAttention, 'new_level' => $newAttention, 'change' => $attentionChange, 'honeypot_used' => $newAttention == $effects['attention_reset'] && $effects['attention_reset'] !== null ]; } private function calculateVisitorChanges() { $effects = $this->upgradeManager->calculateVisitorEffects(); $baseVisitors = $effects['base_visitors']; $visitors = $this->calculateVisitors($baseVisitors, $effects); $revenue = $this->calculateVisitorRevenue(); $attention = $this->calculateAttentionIncrease(); return [ 'visitors' => $visitors, 'revenue' => $revenue, 'attention' => $attention ]; } private function loadGameState() { $this->gameState = $this->db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); } public function updateVisitorsAndAttention() { $this->loadGameState(); $visitorsInfo = $this->calculateVisitorChanges(); $adInfo = $this->adController->updateAdImpressions(); $expiredAds = $this->adController->checkExpiredCampaigns(); $this->adController->generateAdOffers(); if (isset($adInfo)) { $visitorsInfo['ad_info'] = $adInfo; } if (!empty($expiredAds)) { $visitorsInfo['expired_ads'] = $expiredAds; } return $visitorsInfo; } public function calculatePotentialVisitors() { $total = 0; $software = $this->gameState->getSoftware(); foreach ($software as $item) { if ($item['uploaded']) { $typeMultiplier = 1; if ($item['type'] == 'OS') { $typeMultiplier = 1.5; } else if ($item['type'] == 'Game') { $typeMultiplier = 2; } $yearMultiplier = 1.0; if ($item['release_year'] <= 2005) { $yearMultiplier = 0.3; } else if ($item['release_year'] <= 2010) { $yearMultiplier = 0.7; } $visitors = $item['popularity'] * 3 * $typeMultiplier * $yearMultiplier; $total += round($visitors); } } return $total; } } 